/*
 * Decompiled with CFR 0.152.
 */
package com.vinlanx.gunfireoverhaul;

import com.vinlanx.gunfireoverhaul.Config;
import com.vinlanx.gunfireoverhaul.PacketHandler;
import com.vinlanx.gunfireoverhaul.PlayTrackedSoundPacket;
import com.vinlanx.gunfireoverhaul.ServerGunfireHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class AmbientGunfireManager {
    private static final Map<UUID, PlayerTimer> playerTimers = new HashMap<UUID, PlayerTimer>();

    public static void onServerTick(Level level) {
        if (!((Boolean)Config.COMMON.ambient.enableAmbientGunfire.get()).booleanValue()) {
            if (!playerTimers.isEmpty()) {
                playerTimers.clear();
            }
            return;
        }
        if (!level.m_5776_() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (ServerPlayer player : serverLevel.m_6907_()) {
                PlayerTimer timer = playerTimers.computeIfAbsent(player.m_20148_(), id -> new PlayerTimer(level.m_213780_()));
                timer.tick(player);
            }
        }
    }

    private static class PlayerTimer {
        private final RandomSource random;
        private int timeUntilNextEvent;

        PlayerTimer(RandomSource random) {
            this.random = random;
            this.resetTimer();
        }

        private void resetTimer() {
            int max;
            int min = (Integer)Config.COMMON.ambient.minTimeBetweenShots.get();
            this.timeUntilNextEvent = min >= (max = ((Integer)Config.COMMON.ambient.maxTimeBetweenShots.get()).intValue()) ? min : this.random.m_216339_(min, max);
        }

        public void tick(ServerPlayer player) {
            if (this.timeUntilNextEvent-- <= 0) {
                this.generateAndPlayAmbientEventForPlayer(player);
                this.resetTimer();
            }
        }

        private void generateAndPlayAmbientEventForPlayer(ServerPlayer player) {
            int autoWeight;
            int burstWeight;
            if (ServerGunfireHandler.isInNaturalCave(player.m_9236_(), player.m_20183_())) {
                return;
            }
            Config.Common.Ambient.Scenarios scenarios = Config.COMMON.ambient.scenarios;
            int singleWeight = (Integer)scenarios.singleShotWeight.get();
            int totalWeight = singleWeight + (burstWeight = ((Integer)scenarios.burstFireWeight.get()).intValue()) + (autoWeight = ((Integer)scenarios.fullAutoWeight.get()).intValue());
            if (totalWeight <= 0) {
                return;
            }
            int roll = this.random.m_188503_(totalWeight);
            AmbientEventType eventType = (roll -= singleWeight) < 0 ? AmbientEventType.SINGLE : ((roll -= burstWeight) < 0 ? AmbientEventType.BURST_FIRE : AmbientEventType.FULL_AUTO);
            Vec3 eventPos = this.generateEventPosition(player);
            SoundEnvironment chosenEnv = SoundEnvironment.SURFACE;
            if (!((Boolean)Config.COMMON.ambient.soundTypes.enableSurfaceSounds.get()).booleanValue()) {
                return;
            }
            ArrayList<AmbientSoundData> soundsToPlay = new ArrayList<AmbientSoundData>();
            float power = this.generatePower();
            if (power <= 0.0f) {
                return;
            }
            switch (eventType) {
                case SINGLE: {
                    soundsToPlay.add(new AmbientSoundData(power, 0L));
                    break;
                }
                case BURST_FIRE: {
                    int i;
                    int minShots = (Integer)scenarios.minBurstShots.get();
                    int maxShots = (Integer)scenarios.maxBurstShots.get();
                    int shotCount = minShots >= maxShots ? minShots : this.random.m_216339_(minShots, maxShots + 1);
                    long cumulativeDelay = 0L;
                    for (i = 0; i < shotCount; ++i) {
                        int maxDelay;
                        int minDelay = (Integer)scenarios.minTimeBetweenBurstShots.get();
                        soundsToPlay.add(new AmbientSoundData(power, cumulativeDelay += minDelay >= (maxDelay = ((Integer)scenarios.maxTimeBetweenBurstShots.get()).intValue()) ? (long)minDelay : (long)this.random.m_216339_(minDelay, maxDelay + 1)));
                    }
                    break;
                }
                case FULL_AUTO: {
                    int i;
                    int minShots = (Integer)scenarios.minFullAutoShots.get();
                    int maxShots = (Integer)scenarios.maxFullAutoShots.get();
                    int shotCount = minShots >= maxShots ? minShots : this.random.m_216339_(minShots, maxShots + 1);
                    long delayBetween = ((Integer)scenarios.timeBetweenFullAutoShots.get()).intValue();
                    for (i = 0; i < shotCount; ++i) {
                        soundsToPlay.add(new AmbientSoundData(power, (long)i * delayBetween));
                    }
                    break;
                }
            }
            for (AmbientSoundData soundData : soundsToPlay) {
                this.playSoundForEnvironment(player, player.m_9236_(), soundData.power(), chosenEnv, soundData.delay(), eventPos);
            }
        }

        private Vec3 generateEventPosition(ServerPlayer player) {
            int maxDst;
            int minDst = (Integer)Config.COMMON.ambient.minGunfireDistance.get();
            double distance = minDst >= (maxDst = ((Integer)Config.COMMON.ambient.maxGunfireDistance.get()).intValue()) ? (double)minDst : (double)minDst + this.random.m_188500_() * (double)(maxDst - minDst);
            double angle = this.random.m_188500_() * 2.0 * Math.PI;
            double x = player.m_20185_() + Math.cos(angle) * distance;
            double z = player.m_20189_() + Math.sin(angle) * distance;
            return new Vec3(x, player.m_20186_(), z);
        }

        private float generatePower() {
            Config.Common.Ambient.PowerTiers weights = Config.COMMON.ambient.powerTiers;
            int totalWeight = (Integer)weights.tier1_weight.get() + (Integer)weights.tier2_weight.get() + (Integer)weights.tier3_weight.get() + (Integer)weights.tier4_weight.get() + (Integer)weights.tier5_weight.get();
            if (totalWeight <= 0) {
                return 0.0f;
            }
            int roll = this.random.m_188503_(totalWeight);
            if ((roll -= ((Integer)weights.tier1_weight.get()).intValue()) < 0) {
                return 1.0f + this.random.m_188501_() * 14.0f;
            }
            if ((roll -= ((Integer)weights.tier2_weight.get()).intValue()) < 0) {
                return 16.0f + this.random.m_188501_() * 24.0f;
            }
            if ((roll -= ((Integer)weights.tier3_weight.get()).intValue()) < 0) {
                return 41.0f + this.random.m_188501_() * 39.0f;
            }
            if ((roll -= ((Integer)weights.tier4_weight.get()).intValue()) < 0) {
                return 81.0f + this.random.m_188501_() * 39.0f;
            }
            return 121.0f + this.random.m_188501_() * 39.0f;
        }

        private String getCaliberForPower(float power) {
            if (power <= 15.0f) {
                return "9mm";
            }
            if (power <= 40.0f) {
                return "556x45";
            }
            if (power <= 80.0f) {
                return "308";
            }
            if (power <= 120.0f) {
                return "338";
            }
            return "50bmg";
        }

        private void playSoundForEnvironment(ServerPlayer player, Level level, float power, SoundEnvironment env, long baseDelay, Vec3 eventPos) {
            double distance = player.m_20182_().m_82554_(eventPos);
            String caliberId = this.getCaliberForPower(power);
            SoundEvent sound = ServerGunfireHandler.getSoundForCaliber(caliberId, distance);
            if (sound == null) {
                return;
            }
            ResourceLocation soundId = ForgeRegistries.SOUND_EVENTS.getKey((Object)sound);
            if (soundId == null) {
                return;
            }
            float volume = Math.min(power * 10.0f, 120.0f);
            float pitch = 0.95f + this.random.m_188501_() * 0.1f;
            double speedOfSound = 17.15;
            long delayTicks = baseDelay + (long)(distance / speedOfSound);
            boolean playerInHouse = ServerGunfireHandler.isInHouse(level, player.m_20183_(), player.m_146892_().f_82480_);
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PlayTrackedSoundPacket(eventPos, soundId, volume, pitch, delayTicks, playerInHouse));
        }
    }

    private record AmbientSoundData(float power, long delay) {
    }

    private static enum AmbientEventType {
        SINGLE,
        BURST_FIRE,
        FULL_AUTO;

    }

    private static enum SoundEnvironment {
        SURFACE;

    }
}

